package view;

import java.awt.Color;
import java.awt.Graphics;

import model.Box;

public class SimpleBoxDrawer implements BoxDrawer {

	private int boxDimension;

	public SimpleBoxDrawer(int i) {
		this.boxDimension = i;
	}

	@Override
	public void draw(Box box, Graphics g, int x, int y) {
		g.setColor(Color.GRAY);
		if (box.isMarked()) {
			g.setColor(Color.RED);
		}
		g.fillRect(x*boxDimension, y*boxDimension, boxDimension, boxDimension);
		g.setColor(Color.BLACK);
		g.drawRect(x*boxDimension, y*boxDimension, boxDimension, boxDimension);
	}

	
}
